/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */  

/**
 * \file    ddr3.h
 *
 * \brief   Support routines for DDR test application
 *
 * This file contains the support function for DDR Test application.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

#ifndef _DDR_3_H_
#define _DDR_3_H_

#define DDR0_CTRL		 0
//#define CENTAURUS_DDR3_TEST 1

#define DDR0_BASE        0x80000000  // Start of DDR0
#ifdef CENTAURUS_DDR3_TEST
#define DDR0_SIZE        0x20000000  // 512 MB
#else
#define DDR0_SIZE        0x20000000  // 512 MB
#endif
#define DDR_BANK_SIZE	 0x01000000

#define DDR1_BASE 		 0xA0000000
#define DDR1_SIZE        0x20000000

#define DDR_MEM_BANK	8
#define DDR0_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR1_BANK_NUM	(DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK + DDR_MEM_BANK)
#define DDR_RW_SIZE		(16 * 1024)

/* ------------------------------------------------------------------------ *
 *  DDR0 Controller                                                         *
 * ------------------------------------------------------------------------ */
#define DDR_EMIF0_BASE  0x4C000000



/* ------------------------------------------------------------------------ *
 *  Prototype                                                               *
 * ------------------------------------------------------------------------ */
INT32 ddr3_test (void *testargs);
void ddr3_init(void);
void ddr3_read( UINT16 *pSrc, UINT16 *pDst, UINT32 length );
void ddr3_write( UINT16 *pSrc, UINT16 *pDst, UINT32 length );
#endif /* _DDR_3_H_ */
